package com.ejie.ab04b.dao.nora;

import java.util.List;

import com.ejie.ab04b.model.nora.Calle;

/**
 * CalleDao.
 * 
 * @author GFI
 */
public interface CalleDao {

	/**
	 * Finds a single row in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  Calle
	 *
	 * @param calle the calle
	 * @return the calle
	 */
	Calle find(Calle calle);

	/**
	 * Finds a List of rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  List
	 *
	 * @param calle the calle
	 * @return the list
	 */
	List<Calle> findAll(Calle calle);

	/**
	 * Finds a List of rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param calle the calle
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<Calle> findAllLike(Calle calle, Boolean startsWith);

	/**
	 * Counts rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  Long
	 *
	 * @param calle the calle
	 * @return the long
	 */
	Long findAllCount(Calle calle);

	/**
	 * Counts rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param calle the calle
	 * @param startsWith the starts with
	 * @return the long
	 */
	Long findAllLikeCount(Calle calle, Boolean startsWith);
}
